/*
 * Decompiled with CFR 0.152.
 */
package com.adaptivescale.proedms.jdbcdriver;

import com.adaptivescale.proedms.jdbcdriver.ProedmsMeta;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Properties;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.ConnectStringParser;
import org.apache.calcite.avatica.ConnectionConfig;
import org.apache.calcite.avatica.DriverVersion;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.UnregisteredDriver;
import org.apache.calcite.avatica.remote.AvaticaHttpClient;
import org.apache.calcite.avatica.remote.AvaticaHttpClientFactory;
import org.apache.calcite.avatica.remote.KerberosConnection;
import org.apache.calcite.avatica.remote.MockJsonService;
import org.apache.calcite.avatica.remote.ProtobufTranslationImpl;
import org.apache.calcite.avatica.remote.RemoteProtobufService;
import org.apache.calcite.avatica.remote.Service;

public class ProedmsJdbcDriver
extends UnregisteredDriver {
    public static final String CONNECT_STRING_PREFIX = "jdbc:proedms:";

    @Override
    protected DriverVersion createDriverVersion() {
        return DriverVersion.load(ProedmsJdbcDriver.class, "org-apache-calcite-jdbc.properties", "Proedms JDBC Driver", "1.0.0", "Proedms", "0.1");
    }

    @Override
    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    @Override
    public Meta createMeta(AvaticaConnection connection) {
        ConnectionConfig config = connection.config();
        KerberosConnection kerberosUtil = this.createKerberosUtility(config);
        if (null != kerberosUtil) {
            kerberosUtil.login();
            connection.setKerberosConnection(kerberosUtil);
        }
        Service service = this.createService(connection, config);
        connection.setService(service);
        return new ProedmsMeta(connection, service);
    }

    KerberosConnection createKerberosUtility(ConnectionConfig config) {
        String principal = config.kerberosPrincipal();
        if (null != principal) {
            return new KerberosConnection(principal, config.kerberosKeytab());
        }
        return null;
    }

    Service createService(AvaticaConnection connection, ConnectionConfig config) {
        Service service;
        Service.Factory metaFactory = config.factory();
        if (metaFactory != null) {
            service = metaFactory.create(connection);
        } else if (config.url() != null) {
            AvaticaHttpClient httpClient = this.getHttpClient(connection, config);
            service = new RemoteProtobufService(httpClient, new ProtobufTranslationImpl());
        } else {
            service = new MockJsonService(Collections.emptyMap());
        }
        return service;
    }

    AvaticaHttpClient getHttpClient(AvaticaConnection connection, ConnectionConfig config) {
        URL url;
        try {
            url = new URL(config.url());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        AvaticaHttpClientFactory httpClientFactory = config.httpClientFactory();
        return httpClientFactory.getClient(url, config, connection.getKerberosConnection());
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        AvaticaConnection conn = (AvaticaConnection)super.connect(url, info);
        if (conn == null) {
            return null;
        }
        Properties info2 = this.workaroundSetInfo(url, info);
        Service service = conn.getService();
        assert (null != service);
        service.apply(new Service.OpenConnectionRequest(conn.id, Service.OpenConnectionRequest.serializeProperties(info2)));
        return conn;
    }

    private Properties workaroundSetInfo(String url, Properties info) throws SQLException {
        String prefix = this.getConnectStringPrefix();
        assert (url.startsWith(prefix));
        String urlSuffix = url.substring(prefix.length());
        return ConnectStringParser.parse(urlSuffix, info);
    }

    static {
        new ProedmsJdbcDriver().register();
    }
}

